using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgPatientRecordReportCriteria
	/// </summary>
	public class DlgPatientRecordReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.PatientRecordReport _report;
		//
		private System.Windows.Forms.GroupBox grpImage1;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpReportSections;
		private System.Windows.Forms.CheckBox cbDemographics;
		private System.Windows.Forms.CheckBox cbSpecimen;
		private System.Windows.Forms.CheckBox cbTesting;
		private System.Windows.Forms.CheckBox cbUnitAssignment;
		private System.Windows.Forms.CheckBox cbTransfusion;
		private System.Windows.Forms.CheckBox cbTransfusionReaction;
		private System.Windows.Forms.CheckBox cbTransfusionRequirements;
		private System.Windows.Forms.CheckBox cbSpecialInstructions;
		private System.Windows.Forms.CheckBox cbExceptionReport;
		private System.Windows.Forms.Button btnUncheckAll;
		private System.Windows.Forms.Button btnCheckAll;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private System.Windows.Forms.GroupBox grpPatient;
		private System.Windows.Forms.Label lblPatientName;
		private System.Windows.Forms.Label lblPatientID;
		private System.Windows.Forms.TextBox txtPatientName;
		private System.Windows.Forms.TextBox txtPatientID;
		private System.Windows.Forms.Button btnSelectPatient;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgPatientRecordReportCriteria()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this._report = new BOL.PatientRecordReport();
			this._report.Valid += new System.EventHandler(this.CheckValid);
			this._report.Invalid += new System.EventHandler(this.CheckValid);
			this._report.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			this._report.SetInitialBrokenRules(this.Name);

			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgPatientRecordReportCriteria));
			this.grpImage1 = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpReportSections = new System.Windows.Forms.GroupBox();
			this.btnCheckAll = new System.Windows.Forms.Button();
			this.btnUncheckAll = new System.Windows.Forms.Button();
			this.cbExceptionReport = new System.Windows.Forms.CheckBox();
			this.cbSpecialInstructions = new System.Windows.Forms.CheckBox();
			this.cbTransfusionRequirements = new System.Windows.Forms.CheckBox();
			this.cbTransfusionReaction = new System.Windows.Forms.CheckBox();
			this.cbTransfusion = new System.Windows.Forms.CheckBox();
			this.cbUnitAssignment = new System.Windows.Forms.CheckBox();
			this.cbTesting = new System.Windows.Forms.CheckBox();
			this.cbSpecimen = new System.Windows.Forms.CheckBox();
			this.cbDemographics = new System.Windows.Forms.CheckBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.grpPatient = new System.Windows.Forms.GroupBox();
			this.btnSelectPatient = new System.Windows.Forms.Button();
			this.txtPatientID = new System.Windows.Forms.TextBox();
			this.txtPatientName = new System.Windows.Forms.TextBox();
			this.lblPatientID = new System.Windows.Forms.Label();
			this.lblPatientName = new System.Windows.Forms.Label();
			this.grpImage1.SuspendLayout();
			this.grpReportSections.SuspendLayout();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.grpPatient.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(456, 30);
			this.vbecsLogo1.TabIndex = 5;
			this.vbecsLogo1.Title = "Patient History Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 397);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// grpImage1
			// 
			this.grpImage1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage1.Controls.Add(this.pictureBox1);
			this.grpImage1.Location = new System.Drawing.Point(4, 32);
			this.grpImage1.Name = "grpImage1";
			this.grpImage1.Size = new System.Drawing.Size(52, 344);
			this.grpImage1.TabIndex = 6;
			this.grpImage1.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpReportSections
			// 
			this.grpReportSections.AccessibleDescription = "Include Report Sections";
			this.grpReportSections.AccessibleName = "Include Report Sections";
			this.grpReportSections.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportSections.Controls.Add(this.btnCheckAll);
			this.grpReportSections.Controls.Add(this.btnUncheckAll);
			this.grpReportSections.Controls.Add(this.cbExceptionReport);
			this.grpReportSections.Controls.Add(this.cbSpecialInstructions);
			this.grpReportSections.Controls.Add(this.cbTransfusionRequirements);
			this.grpReportSections.Controls.Add(this.cbTransfusionReaction);
			this.grpReportSections.Controls.Add(this.cbTransfusion);
			this.grpReportSections.Controls.Add(this.cbUnitAssignment);
			this.grpReportSections.Controls.Add(this.cbTesting);
			this.grpReportSections.Controls.Add(this.cbSpecimen);
			this.grpReportSections.Controls.Add(this.cbDemographics);
			this.grpReportSections.Location = new System.Drawing.Point(60, 104);
			this.grpReportSections.Name = "grpReportSections";
			this.grpReportSections.Size = new System.Drawing.Size(392, 144);
			this.grpReportSections.TabIndex = 1;
			this.grpReportSections.TabStop = false;
			this.grpReportSections.Text = "Include Report Sections*";
			// 
			// btnCheckAll
			// 
			this.btnCheckAll.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCheckAll.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnCheckAll.Image = ((System.Drawing.Image)(resources.GetObject("btnCheckAll.Image")));
			this.btnCheckAll.Location = new System.Drawing.Point(368, 0);
			this.btnCheckAll.Name = "btnCheckAll";
			this.btnCheckAll.Size = new System.Drawing.Size(16, 16);
			this.btnCheckAll.TabIndex = 10;
			this.btnCheckAll.Click += new System.EventHandler(this.CheckAllSections);
			// 
			// btnUncheckAll
			// 
			this.btnUncheckAll.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnUncheckAll.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnUncheckAll.Image = ((System.Drawing.Image)(resources.GetObject("btnUncheckAll.Image")));
			this.btnUncheckAll.Location = new System.Drawing.Point(352, 0);
			this.btnUncheckAll.Name = "btnUncheckAll";
			this.btnUncheckAll.Size = new System.Drawing.Size(16, 16);
			this.btnUncheckAll.TabIndex = 9;
			this.btnUncheckAll.Click += new System.EventHandler(this.UncheckAllSections);
			// 
			// cbExceptionReport
			// 
			this.cbExceptionReport.AccessibleDescription = "Exception Report";
			this.cbExceptionReport.AccessibleName = "Exception Report";
			this.cbExceptionReport.Location = new System.Drawing.Point(204, 116);
			this.cbExceptionReport.Name = "cbExceptionReport";
			this.cbExceptionReport.Size = new System.Drawing.Size(168, 20);
			this.cbExceptionReport.TabIndex = 8;
			this.cbExceptionReport.Text = "E&xception Report Entries";
			this.cbExceptionReport.CheckedChanged += new System.EventHandler(this.IncludeExceptionsChanged);
			// 
			// cbSpecialInstructions
			// 
			this.cbSpecialInstructions.AccessibleDescription = "Special Instructions";
			this.cbSpecialInstructions.AccessibleName = "Special Instructions";
			this.cbSpecialInstructions.Location = new System.Drawing.Point(204, 44);
			this.cbSpecialInstructions.Name = "cbSpecialInstructions";
			this.cbSpecialInstructions.Size = new System.Drawing.Size(168, 20);
			this.cbSpecialInstructions.TabIndex = 6;
			this.cbSpecialInstructions.Text = "Special &Instructions";
			this.cbSpecialInstructions.CheckedChanged += new System.EventHandler(this.IncludeSpecialInstructionsChanged);
			// 
			// cbTransfusionRequirements
			// 
			this.cbTransfusionRequirements.AccessibleDescription = "Transfusion Requirements";
			this.cbTransfusionRequirements.AccessibleName = "Transfusion Requirements";
			this.cbTransfusionRequirements.Location = new System.Drawing.Point(8, 44);
			this.cbTransfusionRequirements.Name = "cbTransfusionRequirements";
			this.cbTransfusionRequirements.Size = new System.Drawing.Size(168, 20);
			this.cbTransfusionRequirements.TabIndex = 1;
			this.cbTransfusionRequirements.Text = "Transfusion Re&quirements";
			this.cbTransfusionRequirements.CheckedChanged += new System.EventHandler(this.IncludeTransfusionRequirementsChanged);
			// 
			// cbTransfusionReaction
			// 
			this.cbTransfusionReaction.AccessibleDescription = "Transfusion Reaction Details";
			this.cbTransfusionReaction.AccessibleName = "Transfusion Reaction Details";
			this.cbTransfusionReaction.Location = new System.Drawing.Point(204, 68);
			this.cbTransfusionReaction.Name = "cbTransfusionReaction";
			this.cbTransfusionReaction.Size = new System.Drawing.Size(176, 20);
			this.cbTransfusionReaction.TabIndex = 7;
			this.cbTransfusionReaction.Text = "Transfusion &Reaction Details";
			this.cbTransfusionReaction.CheckedChanged += new System.EventHandler(this.IncludeTransfusionReactionsChanged);
			// 
			// cbTransfusion
			// 
			this.cbTransfusion.AccessibleDescription = "Transfusion History";
			this.cbTransfusion.AccessibleName = "Transfusion History";
			this.cbTransfusion.Location = new System.Drawing.Point(8, 116);
			this.cbTransfusion.Name = "cbTransfusion";
			this.cbTransfusion.Size = new System.Drawing.Size(168, 20);
			this.cbTransfusion.TabIndex = 4;
			this.cbTransfusion.Text = "Transfusion &History";
			this.cbTransfusion.CheckedChanged += new System.EventHandler(this.IncludeTransfusionsChanged);
			// 
			// cbUnitAssignment
			// 
			this.cbUnitAssignment.AccessibleDescription = "Unit Assignment History";
			this.cbUnitAssignment.AccessibleName = "Unit Assignment History";
			this.cbUnitAssignment.Location = new System.Drawing.Point(8, 92);
			this.cbUnitAssignment.Name = "cbUnitAssignment";
			this.cbUnitAssignment.Size = new System.Drawing.Size(168, 20);
			this.cbUnitAssignment.TabIndex = 3;
			this.cbUnitAssignment.Text = "&Unit Assignment History";
			this.cbUnitAssignment.CheckedChanged += new System.EventHandler(this.IncludeUnitAssignmentsChanged);
			// 
			// cbTesting
			// 
			this.cbTesting.AccessibleDescription = "Testing Details";
			this.cbTesting.AccessibleName = "Testing Details";
			this.cbTesting.Location = new System.Drawing.Point(8, 68);
			this.cbTesting.Name = "cbTesting";
			this.cbTesting.Size = new System.Drawing.Size(168, 20);
			this.cbTesting.TabIndex = 2;
			this.cbTesting.Text = "&Testing Details";
			this.cbTesting.CheckedChanged += new System.EventHandler(this.IncludeTestingChanged);
			// 
			// cbSpecimen
			// 
			this.cbSpecimen.AccessibleDescription = "Specimen Details";
			this.cbSpecimen.AccessibleName = "Specimen Details";
			this.cbSpecimen.Location = new System.Drawing.Point(204, 20);
			this.cbSpecimen.Name = "cbSpecimen";
			this.cbSpecimen.Size = new System.Drawing.Size(168, 20);
			this.cbSpecimen.TabIndex = 5;
			this.cbSpecimen.Text = "&Specimen Details";
			this.cbSpecimen.CheckedChanged += new System.EventHandler(this.IncludeSpecimensChanged);
			// 
			// cbDemographics
			// 
			this.cbDemographics.AccessibleDescription = "Patient Demographic History";
			this.cbDemographics.AccessibleName = "Patient Demographic History";
			this.cbDemographics.Location = new System.Drawing.Point(8, 20);
			this.cbDemographics.Name = "cbDemographics";
			this.cbDemographics.Size = new System.Drawing.Size(176, 20);
			this.cbDemographics.TabIndex = 0;
			this.cbDemographics.Text = "&Patient Demographic History";
			this.cbDemographics.CheckedChanged += new System.EventHandler(this.IncludeDemographicsChanged);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(376, 380);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.ClickCancel);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(296, 380);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.ClickOK);
			this.btnOK.MouseHover += new System.EventHandler(this.HoverOK);
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.AccessibleDescription = "Report Compilation";
			this.grpReportCompilation.AccessibleName = "Report Compilation";
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 252);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(392, 124);
			this.grpReportCompilation.TabIndex = 2;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.AccessibleDescription = "Schedule Print Job";
			this.rdoScheduleJob.AccessibleName = "Schedule Print Job";
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 40);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.Click += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.AccessibleDescription = "Create Report Now";
			this.rdoCreateNow.AccessibleName = "Create Report Now";
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			this.rdoCreateNow.Click += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 40);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(376, 76);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.AccessibleDescription = "Printer Name";
			this.cmbPrinterName.AccessibleName = "Printer Name";
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.MaxLength = 50;
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(272, 22);
			this.cmbPrinterName.TabIndex = 3;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.PrinterNameChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.AccessibleDescription = "Print Date";
			this.dtpPrintDate.AccessibleName = "Print Date";
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.CustomFormat = "MM/dd/yyyy hh:mm";
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(272, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.PrintDateChanged);
			// 
			// grpPatient
			// 
			this.grpPatient.AccessibleDescription = "Patient";
			this.grpPatient.AccessibleName = "Patient";
			this.grpPatient.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPatient.Controls.Add(this.btnSelectPatient);
			this.grpPatient.Controls.Add(this.txtPatientID);
			this.grpPatient.Controls.Add(this.txtPatientName);
			this.grpPatient.Controls.Add(this.lblPatientID);
			this.grpPatient.Controls.Add(this.lblPatientName);
			this.grpPatient.Location = new System.Drawing.Point(60, 32);
			this.grpPatient.Name = "grpPatient";
			this.grpPatient.Size = new System.Drawing.Size(392, 68);
			this.grpPatient.TabIndex = 0;
			this.grpPatient.TabStop = false;
			this.grpPatient.Text = "Patient*";
			// 
			// btnSelectPatient
			// 
			this.btnSelectPatient.AccessibleDescription = "find";
			this.btnSelectPatient.AccessibleName = "find";
			this.btnSelectPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectPatient.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSelectPatient.Location = new System.Drawing.Point(352, 16);
			this.btnSelectPatient.Name = "btnSelectPatient";
			this.btnSelectPatient.Size = new System.Drawing.Size(24, 20);
			this.btnSelectPatient.TabIndex = 4;
			this.btnSelectPatient.Text = "find";
			this.btnSelectPatient.Click += new System.EventHandler(this.PatientSearch);
			// 
			// txtPatientID
			// 
			this.txtPatientID.AccessibleDescription = "Patient I D";
			this.txtPatientID.AccessibleName = "Patient I D";
			this.txtPatientID.Location = new System.Drawing.Point(68, 40);
			this.txtPatientID.Name = "txtPatientID";
			this.txtPatientID.ReadOnly = true;
			this.txtPatientID.Size = new System.Drawing.Size(128, 20);
			this.txtPatientID.TabIndex = 3;
			this.txtPatientID.TabStop = false;
			this.txtPatientID.Text = "";
			// 
			// txtPatientName
			// 
			this.txtPatientName.AccessibleDescription = "Name";
			this.txtPatientName.AccessibleName = "Name";
			this.txtPatientName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatientName.Location = new System.Drawing.Point(68, 16);
			this.txtPatientName.Name = "txtPatientName";
			this.txtPatientName.ReadOnly = true;
			this.txtPatientName.Size = new System.Drawing.Size(284, 20);
			this.txtPatientName.TabIndex = 1;
			this.txtPatientName.TabStop = false;
			this.txtPatientName.Text = "";
			// 
			// lblPatientID
			// 
			this.lblPatientID.Location = new System.Drawing.Point(8, 40);
			this.lblPatientID.Name = "lblPatientID";
			this.lblPatientID.Size = new System.Drawing.Size(100, 20);
			this.lblPatientID.TabIndex = 2;
			this.lblPatientID.Text = "Patient ID";
			this.lblPatientID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPatientName
			// 
			this.lblPatientName.Location = new System.Drawing.Point(8, 16);
			this.lblPatientName.Name = "lblPatientName";
			this.lblPatientName.Size = new System.Drawing.Size(100, 20);
			this.lblPatientName.TabIndex = 0;
			this.lblPatientName.Text = "Name";
			this.lblPatientName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// DlgPatientRecordReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(456, 413);
			this.Controls.Add(this.grpPatient);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpReportSections);
			this.Controls.Add(this.grpImage1);
			this.hlphelpChm.SetHelpKeyword(this, "Patient_History_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(464, 440);
			this.Name = "DlgPatientRecordReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Patient History Report";
			this.Load += new System.EventHandler(this.DlgPatientRecordReportCriteria_Load);
			this.Controls.SetChildIndex(this.grpImage1, 0);
			this.Controls.SetChildIndex(this.grpReportSections, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.Controls.SetChildIndex(this.grpPatient, 0);
			this.grpImage1.ResumeLayout(false);
			this.grpReportSections.ResumeLayout(false);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.grpPatient.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gets Patient history report object
		/// </summary>
		public BOL.PatientRecordReport Report
		{
			get
			{
				return this._report;
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC101.DlgPatientRecordReportCriteria());
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.btnOK.Text = "&OK";
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			//
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			//BR_77.01
			this.dtpPrintDate.Value = currentDate;
			//
			LoadPrinters();
			//
			this.cbDemographics.Checked = this._report.IncludePatientDemographics;
			this.cbExceptionReport.Checked = this._report.IncludePatientExceptionReports;
			this.cbSpecialInstructions.Checked = this._report.IncludePatientSpecialInstructions;
			this.cbSpecimen.Checked = this._report.IncludePatientSpecimens;
			this.cbTesting.Checked = this._report.IncludePatientTesting;
			this.cbTransfusion.Checked = this._report.IncludePatientTransfusions;
			this.cbTransfusionReaction.Checked = this._report.IncludePatientTransfusionReactions;
			this.cbTransfusionRequirements.Checked = this._report.IncludePatientTransfusionRequirements;
			this.cbUnitAssignment.Checked = this._report.IncludePatientUnitAssignments;
		}

		private void LoadPrinters()
		{
			this.cmbPrinterName.Items.Clear();
			//
			foreach (string printerName in BOL.VbecsReport.GetPrinters())
			{
				cmbPrinterName.Items.Add(printerName);
			}
		}

		private void ReportCompilationChanged(object sender, System.EventArgs e)
		{
			this._report.IsScheduled = (this.rdoScheduleJob.Checked);
			this.grpScheduleJob.Enabled = (this.rdoScheduleJob.Checked);
			if ((this._report.IsScheduled) && (this._report.PrintDate == DateTime.MinValue))
			{
				this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			}
		}

		private void ClickOK(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				if (this._report.IsScheduledReportGreaterThanThirtyDays)
				{
					if (DialogResult.Yes != GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.ScheduledReportGreaterThanThirtyDays()))
					{
						return;
					}
				}
				//
				try
				{
					this._report.Schedule();
					this.DialogResult = DialogResult.Cancel;
				}
				catch(BOL.BusinessObjectException)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.ScheduleReportFailed());
					return;
				}
			}
			else
			{
				int count = this._report.GetPatientRecordReportCount();
				//
				if(count==0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.NoInfoReturned());
					return;
				}
				else if((count/20)>=50) //assuming 20 records per page
				{
					DialogResult _result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
					if( _result != DialogResult.Yes )
					{
						return;
					}
					else
					{
						//Alert user that building report may take a few minutes
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.Warning());
					}
				}
				this.DialogResult = DialogResult.OK;
			}
			//
			this.Close();
		}

		private void ClickCancel(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void PrintDateChanged(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				this._report.PrintDate = this.dtpPrintDate.Value;
			}
		}

		private void PrinterNameChanged(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				if(cmbPrinterName.SelectedItem!=null)
				{
					string printer=this.cmbPrinterName.Text;
					for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
					{
						if(printer==this.cmbPrinterName.Items[i].ToString())
						{
							this._report.PrinterName = cmbPrinterName.SelectedItem.ToString();
						}
					}
				}		
				else
				{
					this._report.PrinterName=String.Empty;
				}
			}
		}

		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (this._report.IsValid);
		}

		private void HoverOK(object sender, System.EventArgs e)
		{
			if (this._report.IsValid)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(this._report.GetBrokenRulesMessage(this.Name));
			}
		}

		private void UncheckAllSections(object sender, System.EventArgs e)
		{
			foreach(Control ctrl in this.grpReportSections.Controls)
			{
				if (ctrl.GetType() == typeof(CheckBox))
				{
					((CheckBox)ctrl).Checked = false;
				}
			}
		}

		private void CheckAllSections(object sender, System.EventArgs e)
		{
			foreach(Control ctrl in this.grpReportSections.Controls)
			{
				if (ctrl.GetType() == typeof(CheckBox))
				{
					((CheckBox)ctrl).Checked = true;
				}
			}
		}

		private void PatientSearch(object sender, System.EventArgs e)
		{
			FrmPatientSelect dlg = new FrmPatientSelect(false);
			if (dlg.ShowDialog(this) != DialogResult.OK)
			{
				return;
			}
			this._report.PatientGuid = dlg.SelectedPatient.PatientGuid;
			this.txtPatientName.Text = dlg.SelectedPatient.DisplayName;
			this.txtPatientID.Text = dlg.SelectedPatient.DisplayPatientID;
		}

		private void IncludeDemographicsChanged(object sender, System.EventArgs e)
		{
			this._report.IncludePatientDemographics = this.cbDemographics.Checked;
		}

		private void IncludeTransfusionRequirementsChanged(object sender, System.EventArgs e)
		{
			this._report.IncludePatientTransfusionRequirements = this.cbTransfusionRequirements.Checked;
		}

		private void IncludeTestingChanged(object sender, System.EventArgs e)
		{
			this._report.IncludePatientTesting = this.cbTesting.Checked;
		}

		private void IncludeUnitAssignmentsChanged(object sender, System.EventArgs e)
		{
			this._report.IncludePatientUnitAssignments = this.cbUnitAssignment.Checked;
		}

		private void IncludeTransfusionsChanged(object sender, System.EventArgs e)
		{
			this._report.IncludePatientTransfusions = this.cbTransfusion.Checked;
		}

		private void IncludeSpecimensChanged(object sender, System.EventArgs e)
		{
			this._report.IncludePatientSpecimens = this.cbSpecimen.Checked;
		}

		private void IncludeSpecialInstructionsChanged(object sender, System.EventArgs e)
		{
			this._report.IncludePatientSpecialInstructions = this.cbSpecialInstructions.Checked;
		}

		private void IncludeTransfusionReactionsChanged(object sender, System.EventArgs e)
		{
			this._report.IncludePatientTransfusionReactions = this.cbTransfusionReaction.Checked;
		}

		private void IncludeExceptionsChanged(object sender, System.EventArgs e)
		{
			this._report.IncludePatientExceptionReports = this.cbExceptionReport.Checked;
		}

		private void DlgPatientRecordReportCriteria_Load(object sender, System.EventArgs e)
		{
			this.PatientSearch(sender,e);
		}
	}
}

